﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.AdvancedAPI.MouseProperties
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern int GetSystemMetrics(SysMetr nIndex);

        public enum SysMetr
        {
            SM_SWAPBUTTON = 0x17
        }

        [DllImport("user32.dll")]
        public static extern UInt32 GetDoubleClickTime();

        [DllImport("kernel32.dll")]
        public static extern void Sleep(int miliSecond);

        [DllImport("User32.dll")]
        public static extern IntPtr LoadCursorFromFile(String lpFileName);

        [DllImport("User32.dll")]
        public static extern bool SetSystemCursor(IntPtr hcur, SystemCursorType id);

        public enum SystemCursorType : uint
        {
            OCR_NORMAL = 32512,
            OCR_IBEAM = 32513,
            OCR_WAIT = 32514,
            OCR_CROSS = 32515,
            OCR_UP = 32516,
            OCR_PREC = 32641,
            OCR_SIZENWSE = 32642,
            OCR_SIZENESW = 32643,
            OCR_SIZEWE = 32644,
            OCR_SIZENS = 32645,
            OCR_SIZEALL = 32646,
            OCR_NO = 32648,
            OCR_HAND = 32649,
            OCR_APPSTARTING = 32650,
            OCR_HELP = 32651
        }

        public const UInt32 SPIF_UPDATEINIFILE = 0x1;

        [DllImport("user32.dll", EntryPoint = "SystemParametersInfo", SetLastError = true)]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool SystemParametersInfo(UInt32 uiaction, UInt32 uiParam, ref UInt32 pvParam, UInt32 fWinIni);

        public const UInt32
        SPI_GETMOUSESPEED = 0x0070,
        SPI_GETMOUSESONAR = 0x101C,
        SPI_GETMOUSETRAILS = 0x005E,
        SPI_GETCURSORSHADOW = 0x101A,
        SPI_GETMOUSECLICKLOCK = 0x101E,
        SPI_GETSNAPTODEFBUTTON = 0x005F,
        SPI_GETWHEELSCROLLLINES = 0x0068,
        SPI_GETWHEELSCROLLCHARS = 0x006C,
        SPI_GETMOUSECLICKLOCKTIME = 0x2008;

        [DllImport("User32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        private static extern Boolean SystemParametersInfo(UInt32 uiaction, UInt32 uiParam, UInt32 pvParam, UInt32 fWinIni);

        public const UInt32
        SPI_SETMOUSESPEED = 0x0071,
        SPI_SETMOUSESONAR = 0x101D,
        SPI_SETMOUSETRAILS = 0x005D,
        SPI_btnSetCurSHADOW = 0x101B,
        SPI_SETMOUSECLICKLOCK = 0x101F,
        SPI_SETMOUSEBUTTONSWAP = 0x0021,
        SPI_SETDOUBLECLICKTIME = 0x0020,
        SPI_SETSNAPTODEFBUTTON = 0x0060,
        SPI_SETWHEELSCROLLLINES = 0x0069,
        SPI_SETWHEELSCROLLCHARS = 0x006D,
        SPI_SETMOUSECLICKLOCKTIME = 0x2009;

        [DllImport("User32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        private static extern Boolean SystemParametersInfo(UInt32 uiaction, UInt32 uiParam, bool pvParam, UInt32 fWinIni);

        public const UInt32 SPI_SETMOUSEVANISH = 0x1021;

        [DllImport("User32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        private static extern Boolean SystemParametersInfo(UInt32 uiaction, UInt32 uiParam, ref bool pvParam, UInt32 fWinIni);

        public const UInt32 SPI_GETMOUSEVANISH = 0x1020;

        public bool IsCursorChanges;

        LastValues LastAppliedValues = new LastValues();

        public FormMain()
        {
            InitializeComponent();
        }

        public void Get()
        {
            // 1. Button Swap
            LastAppliedValues.SMB = (UInt32)GetSystemMetrics(SysMetr.SM_SWAPBUTTON);
            if (LastAppliedValues.SMB == 0)
            {
                CheckboxSwapMouseButton.Checked = false;
                PictureLeftClick.Visible = true;
            }
            else
            {
                CheckboxSwapMouseButton.Checked = true;
                PictureLeftClick.Visible = false;
            }

            // 2. Double-Click Time
            LastAppliedValues.DCT = GetDoubleClickTime();
            if (LastAppliedValues.DCT < 200) LastAppliedValues.DCT = 200;
            if (LastAppliedValues.DCT > 900) LastAppliedValues.DCT = 900;
            TrackbarDoubleClickTime.Value = (int)((LastAppliedValues.DCT - 200) / 70);

            // 3. Click-Lock
            SystemParametersInfo(SPI_GETMOUSECLICKLOCK, 0, ref LastAppliedValues.MCL, 0);
            if (LastAppliedValues.MCL == 0)
                CheckboxClickLock.Checked = false;
            else
                CheckboxClickLock.Checked = true;

            // 4. Click-Lock Time
            SystemParametersInfo(SPI_GETMOUSECLICKLOCKTIME, 0, ref LastAppliedValues.MCLT, 0);
            if (LastAppliedValues.MCLT < 200) LastAppliedValues.MCLT = 200;
            if (LastAppliedValues.MCLT > 2200) LastAppliedValues.MCLT = 2200;
            LastAppliedValues.MCLTT = LastAppliedValues.MCLT;
            TrackbarClickLockSpeed.Value = (int)(LastAppliedValues.MCLT / 200);
            dctcaption.Text = LastAppliedValues.MCLT + @" میلی ثانیه";

            // 5. Cursor Shodow
            SystemParametersInfo(SPI_GETCURSORSHADOW, 0, ref LastAppliedValues.CSH, 0);
            if (LastAppliedValues.CSH != 0) CheckboxCursorShadow.Checked = true;
            else CheckboxCursorShadow.Checked = false;

            // 7. Mouse Speed
            SystemParametersInfo(SPI_GETMOUSESPEED, 0, ref LastAppliedValues.MSP, 0);
            TrackbarSpeed.Value = (int)(LastAppliedValues.MSP / 2);

            // 9. SnapToDefButton
            SystemParametersInfo(SPI_GETSNAPTODEFBUTTON, 0, ref LastAppliedValues.STDB, 0);
            if (LastAppliedValues.STDB != 0) CheckboxSnap.Checked = true;

            // 10. Mouse Trails
            SystemParametersInfo(SPI_GETMOUSETRAILS, 0, ref LastAppliedValues.MT, 0);
            if (LastAppliedValues.MT == 0)
            {
                CheckboxTrail.Checked = false;
                TrckbarTrail.Value = 7;
                TrckbarTrail.Enabled = false;
                LabelTrackTrail.ForeColor = SystemColors.ButtonShadow;
            }
            else
            {
                CheckboxTrail.Checked = true;
                TrckbarTrail.Enabled = true;
                TrckbarTrail.Value = (int)LastAppliedValues.MT;
                LabelTrackTrail.ForeColor = SystemColors.ControlText;
            }

            // 11. Mouse Vanish
            SystemParametersInfo(SPI_GETMOUSEVANISH, 0, ref LastAppliedValues.MV, 0);
            if (LastAppliedValues.MV)
                CheckboxPointerHide.Checked = true;
            else
                CheckboxPointerHide.Checked = false;

            // 12. Mouse Sonar
            SystemParametersInfo(SPI_GETMOUSESONAR, 0, ref LastAppliedValues.MSO, 0);
            if (LastAppliedValues.MSO == 0)
                CheckboxCtrl.Checked = false;
            else
                CheckboxCtrl.Checked = true;

            // 13. Wheel Scroll Lines
            SystemParametersInfo(SPI_GETWHEELSCROLLLINES, 0, ref LastAppliedValues.WSL, 0);
            if (LastAppliedValues.WSL > 100 || LastAppliedValues.WSL < 1)
            {
                chkupdownHoScrlPag.Checked = true;
                UpdownVerticalScroll.Enabled = false;
            }
            else
            {
                CheckboxUpdownHorizontalScrollRow.Checked = true;
                UpdownVerticalScroll.Value = (int)(LastAppliedValues.WSL);
            }
            chkupdownHoScrlPag.Enabled = false;

            // 14. Wheel Scroll Chars
            SystemParametersInfo(SPI_GETWHEELSCROLLCHARS, 0, ref LastAppliedValues.WSCH, 0);
            if (LastAppliedValues.WSCH > 0) UpdownHorizontalScroll.Value = LastAppliedValues.WSCH;
        }

        public void Set(int action, UInt32 flag, UInt32 save)
        {
            switch (action)
            {
                case 1: SystemParametersInfo(SPI_SETMOUSEBUTTONSWAP, flag, 0, save); break;
                case 2: SystemParametersInfo(SPI_SETDOUBLECLICKTIME, flag, 0, save); break;
                case 3: SystemParametersInfo(SPI_SETMOUSECLICKLOCK, 0, flag, save); break;
                case 4: SystemParametersInfo(SPI_SETMOUSECLICKLOCKTIME, 0, flag, save); break;
                case 5: SystemParametersInfo(SPI_btnSetCurSHADOW, 0, flag, save); break;
                case 7: SystemParametersInfo(SPI_SETMOUSESPEED, 0, flag, save); break;
                case 9: SystemParametersInfo(SPI_SETSNAPTODEFBUTTON, flag, 0, save); break;
                case 10: SystemParametersInfo(SPI_SETMOUSETRAILS, flag, 0, save); break;
                case 11: SystemParametersInfo(SPI_SETMOUSEVANISH, 0, Convert.ToBoolean(flag), save); break;
                case 12: SystemParametersInfo(SPI_SETMOUSESONAR, 0, flag, save); break;
                case 13: SystemParametersInfo(SPI_SETWHEELSCROLLLINES, flag, 0, save); break;
                case 14: SystemParametersInfo(SPI_SETWHEELSCROLLCHARS, flag, 0, save); break;
            }
            if (save == SPIF_UPDATEINIFILE)
                switch (action)
                {
                    case 1: if (CheckboxSwapMouseButton.Checked) LastAppliedValues.SMB = 1; else LastAppliedValues.SMB = 0; break;
                    case 2: LastAppliedValues.DCT = (UInt32)((TrackbarDoubleClickTime.Value * 70) + 200); break;
                    case 3: if (CheckboxClickLock.Checked) LastAppliedValues.MCL = 1; else LastAppliedValues.MCL = 0; break;
                    case 4: LastAppliedValues.MCLT = (UInt32)(TrackbarClickLockSpeed.Value * 200); break;
                    case 5: if (CheckboxCursorShadow.Checked) LastAppliedValues.CSH = 1; else LastAppliedValues.CSH = 0; break;
                    case 7: LastAppliedValues.MSP = ((UInt32)TrackbarSpeed.Value * 2); break;
                    case 9: if (CheckboxSnap.Checked) LastAppliedValues.STDB = 1; else LastAppliedValues.STDB = 0; break;
                    case 10: if (CheckboxTrail.Checked) LastAppliedValues.MT = (UInt32)TrckbarTrail.Value; else LastAppliedValues.MT = 0; break;
                    case 11: if (CheckboxPointerHide.Checked) LastAppliedValues.MV = true; else LastAppliedValues.MV = false; break;
                    case 12: if (CheckboxCtrl.Checked) LastAppliedValues.MSO = 1; else LastAppliedValues.MSO = 0; break;
                    case 13: LastAppliedValues.WSL = (UInt32)(UpdownVerticalScroll.Value); break;
                    case 14: LastAppliedValues.WSCH = (UInt32)(UpdownHorizontalScroll.Value); break;
                }
            ButtonApply.Enabled = true;
        }

        public void Apply()
        {
            //1.Swap Mouse Buttons
            if (CheckboxSwapMouseButton.Checked) Set(1, 1, SPIF_UPDATEINIFILE); else Set(1, 0, SPIF_UPDATEINIFILE);

            //2.Double Click Time
            Set(2, (UInt32)((TrackbarDoubleClickTime.Value * 70) + 200), SPIF_UPDATEINIFILE);

            //3.Mouse Click-Lock
            if (CheckboxClickLock.Checked) Set(3, 1, SPIF_UPDATEINIFILE); else Set(3, 0, SPIF_UPDATEINIFILE);

            //4.Mouse Click-Lock Time
            Set(4, LastAppliedValues.MCLTT, SPIF_UPDATEINIFILE);

            //5.Cursor Shadow
            if (CheckboxCursorShadow.Checked) Set(5, 1, SPIF_UPDATEINIFILE); else Set(5, 0, SPIF_UPDATEINIFILE);

            //7.Mouse Speed
            Set(7, (UInt32)((TrackbarDoubleClickTime.Value * 70) + 200), SPIF_UPDATEINIFILE);

            //9.Snap To
            if (CheckboxSnap.Checked) Set(9, 1, SPIF_UPDATEINIFILE); else Set(9, 0, SPIF_UPDATEINIFILE);

            //10.Mouse trails
            if (CheckboxTrail.Checked) Set(10, (UInt32)TrckbarTrail.Value, SPIF_UPDATEINIFILE); else Set(10, 0, SPIF_UPDATEINIFILE);

            //11.Mouse Vanish (Hide/Show Cursor In Tiping)
            if (CheckboxPointerHide.Checked) Set(11, 1, SPIF_UPDATEINIFILE); else Set(11, 0, SPIF_UPDATEINIFILE);

            //12.Mouse Sonar
            if (CheckboxCtrl.Checked) Set(12, 1, SPIF_UPDATEINIFILE); else Set(12, 0, SPIF_UPDATEINIFILE);

            //13.Vertical Scroll
            if (UpdownVerticalScroll.Enabled) Set(13, (UInt32)(UpdownVerticalScroll.Value), SPIF_UPDATEINIFILE);

            //14.Horizontal Scroll
            Set(14, (UInt32)(UpdownHorizontalScroll.Value), SPIF_UPDATEINIFILE);
        }

        private void CheckboxClickLock_CheckedChanged(object sender, EventArgs e)
        {
            if (CheckboxClickLock.Checked)
            {
                Set(3, 1, 0);
                ButtonClickLockSet.Enabled = true;
            }
            else
            {
                Set(3, 0, 0);
                ButtonClickLockSet.Enabled = false;
            }
        }

        private void PictureFolderClose_DoubleClick(object sender, EventArgs e)
        {
            PictureFolderClose.Visible = false;
            PictureFolderOpen.Visible = true;
        }

        private void PictureFolderOpen_DoubleClick(object sender, EventArgs e)
        {
            PictureFolderOpen.Visible = false;
            PictureFolderClose.Visible = true;
        }

        private void CheckboxSwapMouseButton_CheckedChanged(object sender, EventArgs e)
        {
            if (CheckboxSwapMouseButton.Checked)
            {
                PictureLeftClick.Visible = false;
                Set(1, 1, 0);
            }
            else
            {
                PictureLeftClick.Visible = true;
                Set(1, 0, 0);
            }
        }

        public void ViewClickLockTimeSet(bool flag)
        {
            if (flag)
            {
                tabControlMouseSetting.Visible = false;
                for (int i = 1; i < 60; i++)
                {
                    Height -= 5;
                    Sleep(5);
                }
                GroupBoxClickLockSpeed.Location = new Point(6, 7);
                Text = @"تنظیمات ماوس - سرعت قفل کلیک";
                ControlBox = false;
                TrackbarClickLockSpeed.TabStop = true; ButtonCancelClickLockSpeed.TabStop = true; ButtonOKClickLockSpeed.TabStop = true;
                ButtonOK.TabStop = false; ButtonCancel.TabStop = false; ButtonApply.TabStop = false;
                AcceptButton = ButtonOKClickLockSpeed;
                TrackbarClickLockSpeed.Focus();
            }
            else
            {
                GroupBoxClickLockSpeed.Location = new Point(6, 430);
                for (int i = 1; i < 60; i++)
                {
                    Height += 5;
                    Sleep(5);
                }
                tabControlMouseSetting.Visible = true;
                ControlBox = true;
                TrackbarClickLockSpeed.TabStop = false; ButtonCancelClickLockSpeed.TabStop = false; ButtonOKClickLockSpeed.TabStop = false;
                ButtonOK.TabStop = true; ButtonCancel.TabStop = true; ButtonApply.TabStop = true;
                Text = @"تنظیمات ماوس";
                AcceptButton = ButtonOK;
                ButtonOK.Focus();
            }
        }

        private void ButtonClickLockSet_Click(object sender, EventArgs e)
        {
            ViewClickLockTimeSet(true);
        }

        private void CheckboxTrail_CheckedChanged(object sender, EventArgs e)
        {
            if (CheckboxTrail.Checked)
            {
                Set(10, (UInt32)TrckbarTrail.Value, 0);
                TrckbarTrail.Enabled = true;
                LabelTrackTrail.ForeColor = SystemColors.ControlText;
            }
            else
            {
                Set(10, 0, 0);
                TrckbarTrail.Enabled = false;
                LabelTrackTrail.ForeColor = SystemColors.ButtonShadow;
            }
        }

        private void TrackbarDoubleClickTime_Scroll(object sender, EventArgs e)
        {
            Set(2, (UInt32)((TrackbarDoubleClickTime.Value * 70) + 200), 0);
        }

        private void TrackbarSpeed_Scroll(object sender, EventArgs e)
        {
            Set(7, (UInt32)TrackbarSpeed.Value * 2, 0);
        }

        private void CheckboxSnap_CheckedChanged(object sender, EventArgs e)
        {
            if (CheckboxSnap.Checked) Set(9, 1, 0); else Set(9, 0, 0);
        }

        private void CheckboxPointerHide_CheckedChanged(object sender, EventArgs e)
        {
            if (CheckboxPointerHide.Checked) Set(11, 1, 0); else Set(11, 0, 0);
        }

        private void CheckboxCtrl_CheckedChanged(object sender, EventArgs e)
        {
            if (CheckboxCtrl.Checked) Set(12, 1, 0); else Set(12, 0, 0);
        }

        private void ButtonCancel_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void ButtonOK_Click(object sender, EventArgs e)
        {
            Apply();
            Application.Exit();
        }

        private void ButtonApply_Click(object sender, EventArgs e)
        {
            Apply();
            ButtonApply.Enabled = false;
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            Get();
            Height = 452;
            Width = 404;
            ListCursors.SetSelected(0, true);
            openFileDialogCursors.InitialDirectory = Environment.GetEnvironmentVariable("windir") + "\\Cursors";
            ButtonApply.Enabled = false;
        }

        private void ButtonSetCursor_Click(object sender, EventArgs e)
        {
            IntPtr cursorHandle = LoadCursorFromFile(TextboxCursorPath.Text);

            int ocr = ListCursors.SelectedIndex;
            switch (ocr)
            {
                case 0: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_NORMAL); break;
                case 1: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_HELP); break;
                case 2: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_APPSTARTING); break;
                case 3: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_WAIT); break;
                case 4: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_IBEAM); break;
                case 5: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_CROSS); break;
                case 6: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_NO); break;
                case 7: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_SIZENS); break;
                case 8: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_SIZEWE); break;
                case 9: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_SIZENWSE); break;
                case 10: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_SIZENESW); break;
                case 11: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_SIZEALL); break;
                case 12: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_UP); break;
                case 13: IsCursorChanges = SetSystemCursor(cursorHandle, SystemCursorType.OCR_HAND); break;
            }

            if (IsCursorChanges)
            {
                MessageBox.Show(String.Format("نشانگر «  {0} » با موفقیت تعویض شد ", ListCursors.Text), @"توجه", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            else
            {
                MessageBox.Show(@"مسیر فایل نشانگر صحیح نیست", @"خطا", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }

            TextboxCursorPath.Text = "";
            ButtonSetCursor.Enabled = false;
            ButtonBrowseCursor.Focus();
        }

        private void CheckboxCursorShadow_CheckedChanged(object sender, EventArgs e)
        {
            if (CheckboxCursorShadow.Checked) Set(5, 1, 0); else Set(5, 0, 0);
        }

        private void UpdownVerticalScroll_ValueChanged(object sender, EventArgs e)
        {
            Set(13, (UInt32)UpdownVerticalScroll.Value, 0);
        }

        private void ButtonBrowseCursor_Click(object sender, EventArgs e)
        {
            DialogResult dr = openFileDialogCursors.ShowDialog();
            if (dr == DialogResult.OK) { ButtonSetCursor.Enabled = true; ButtonSetCursor.Focus(); }
            TextboxCursorPath.Text = openFileDialogCursors.FileName;
        }

        private void ListCursors_Click(object sender, EventArgs e)
        {
            ButtonBrowseCursor.Enabled = true;
            ButtonBrowseCursor.Focus();
        }

        private void ListCursors_SelectedIndexChanged(object sender, EventArgs e)
        {
            int listIndex = ListCursors.SelectedIndex;
            switch (listIndex)
            {
                case 0: PictureCursor.BackgroundImage = PictureCursor0.Image; break;
                case 1: PictureCursor.BackgroundImage = PictureCursor1.Image; break;
                case 2: PictureCursor.BackgroundImage = PictureCursor2.Image; break;
                case 3: PictureCursor.BackgroundImage = PictureCursor3.Image; break;
                case 4: PictureCursor.BackgroundImage = PictureCursor4.Image; break;
                case 5: PictureCursor.BackgroundImage = PictureCursor5.Image; break;
                case 6: PictureCursor.BackgroundImage = PictureCursor6.Image; break;
                case 7: PictureCursor.BackgroundImage = PictureCursor7.Image; break;
                case 8: PictureCursor.BackgroundImage = PictureCursor8.Image; break;
                case 9: PictureCursor.BackgroundImage = PictureCursor9.Image; break;
                case 10: PictureCursor.BackgroundImage = PictureCursor10.Image; break;
                case 11: PictureCursor.BackgroundImage = PictureCursor11.Image; break;
                case 12: PictureCursor.BackgroundImage = PictureCursor12.Image; break;
                case 13: PictureCursor.BackgroundImage = PictureCursor13.Image; break;
            }
        }

        private void TrckbarTrail_Scroll(object sender, EventArgs e)
        {
            Set(10, (UInt32)TrckbarTrail.Value, 0);
        }

        private void UpdownHorizontalScroll_ValueChanged(object sender, EventArgs e)
        {
            Set(14, (UInt32)UpdownHorizontalScroll.Value, 0);
        }

        private void CheckboxUpdownHorizontalScrollRow_CheckedChanged(object sender, EventArgs e)
        {
            UpdownVerticalScroll.Enabled = true;
            UpdownVerticalScroll.Value = 3;
            Set(13, (UInt32)UpdownVerticalScroll.Value, 0);
        }

        private void FormMain_FormClosed(object sender, FormClosedEventArgs e)
        {
            Set(1, LastAppliedValues.SMB, SPIF_UPDATEINIFILE);
            Set(2, LastAppliedValues.DCT, SPIF_UPDATEINIFILE);
            Set(3, LastAppliedValues.MCL, SPIF_UPDATEINIFILE);
            Set(4, LastAppliedValues.MCLT, SPIF_UPDATEINIFILE);
            Set(5, LastAppliedValues.CSH, SPIF_UPDATEINIFILE);
            Set(7, LastAppliedValues.MSP, SPIF_UPDATEINIFILE);
            Set(9, LastAppliedValues.STDB, SPIF_UPDATEINIFILE);
            Set(10, LastAppliedValues.MT, SPIF_UPDATEINIFILE);
            if (LastAppliedValues.MV) Set(11, 1, SPIF_UPDATEINIFILE); else Set(11, 0, SPIF_UPDATEINIFILE);
            Set(12, LastAppliedValues.MSO, SPIF_UPDATEINIFILE);
            if (UpdownVerticalScroll.Enabled) Set(13, LastAppliedValues.WSL, SPIF_UPDATEINIFILE);
            Set(14, LastAppliedValues.WSCH, SPIF_UPDATEINIFILE);
        }

        private void ButtonCancelClickLockSpeed_Click(object sender, EventArgs e)
        {
            TrackbarClickLockSpeed.Value = (int)(LastAppliedValues.MCLTT / 200);
            dctcaption.Text = LastAppliedValues.MCLTT + @" میلی ثانیه";
            ViewClickLockTimeSet(false);
        }

        private void ButtonOKClickLockSpeed_Click(object sender, EventArgs e)
        {
            LastAppliedValues.MCLTT = (UInt32)(TrackbarClickLockSpeed.Value * 200);
            ViewClickLockTimeSet(false);
            ButtonApply.Enabled = true;
        }

        private void TrackbarClickLockSpeed_Scroll(object sender, EventArgs e)
        {
            Set(4, (UInt32)(TrackbarClickLockSpeed.Value * 200), 0);
            dctcaption.Text = (UInt32)(TrackbarClickLockSpeed.Value * 200) + @" میلی ثانیه";
        }

        private void TextboxCursorPath_Click(object sender, EventArgs e)
        {
            ButtonBrowseCursor.Focus();
        }
    }

    public class LastValues
    {
        public UInt32 SMB;
        public UInt32 DCT;
        public UInt32 MCL;
        public UInt32 MCLT;
        public UInt32 MCLTT;
        public UInt32 CSH;
        public UInt32 MSP;
        public UInt32 STDB;
        public UInt32 MT;
        public bool MV;
        public UInt32 MSO;
        public uint WSL;
        public bool WSLF;
        public uint WSCH;
    }
}